#ifndef __Controls__
#define __Controls__

/**
 * @file Controls.h
 * @brief Single include for the Controls package
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: Controls.h,v 1.7 2007/02/08 21:07:54 paul Exp $
 */


/**
 * @namespace Exponent::GUI::Controls
 * @brief Controls that work with the Exponent graphics system
 *
 * Contains all the lightweight graphical controls
 */

#include "CADSREditor.hpp"
#include "CAnimation.hpp"
#include "CAnimationFrame.hpp"
#include "CAreaBox.hpp"
#include "CAutoAnimation.hpp"
#include "CCenterSlider.hpp"
#include "CComboBox.hpp"
#include "CControl.hpp"
#include "CControlPanel.hpp"
#include "CControlRoot.hpp"
#include "CDiskPathMenuItem.hpp"
#include "CHtmlMenuItem.hpp"
#include "CImageLabel.hpp"
#include "CKnob.hpp"
#include "CLatchingButton.hpp"
#include "CLevelMeter.hpp"
#include "CMenu.hpp"
#include "CMenuItem.hpp"
#include "CMenuItemDisplay.hpp"
#include "CModulatedSlider.hpp"
#include "CModulatedXYPad.hpp"
#include "CMomentaryButton.hpp"
#include "CPopupButton.hpp"
#include "CPresetBrowser.hpp"
#include "CProgressBar.hpp"
#include "CRadioButton.hpp"
#include "CRangeSlider.hpp"
#include "CRepeatingButton.hpp"
#include "CRolloverButton.hpp"
#include "CScrollBar.hpp"
#include "CScrollBarImages.hpp"
#include "CScrollPanel.hpp"
#include "CSelectableMenuItem.hpp"
#include "CSlider.hpp"
#include "CSliderArray.hpp"
#include "CStepLabel.hpp"
#include "CSubMenuMenuItem.hpp"
#include "CTextEdit.hpp"
#include "CTextLabel.hpp"
#include "CTriStateImage.hpp"
#include "CWaveCycle.hpp"
#include "CWindowDragTab.hpp"
#include "CXYPad.hpp"
#include "IControlRoot.hpp"
#include "IControl.hpp"
#include "IPresetHandler.hpp"
#include "SMenuColours.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::GUI::Controls;
#endif

#endif	// Controls.h